@ECHO OFF
::············· EDITABLE·VARIABLES···············::
SET "USERNAME=YourUserName"
SET "PASSWORD=YourPassword"
SET "COMMUNITY=YourCommunity"
SET "ROOM_ID=1700000000059439"
SET "LOCAL_PATH=C:/Caveau/uploads"
SET "VERBOSE=false"
::··········· END·EDITABLE·VARIABLES· ···········::

if "%VERBOSE%" == "true" (
  @ECHO ON
)

SET "BASEURL=https://app.digitalcaveau.com"

IF [%1]==[/?] GOTO :help

ECHO %* |FIND "/?" > nul
IF errorlevel 1 GOTO :main

:help
ECHO %~nx0 is a simple script that uploads files into Caveau platform.
ECHO Configuration can be done inside the script by changing the values of the editable variables,
ECHO Otherwise by giving in input positional parameters as shown in the Usage section.
ECHO Usage : %~nx0 [-v] ^<USERNAME^> ^<PASSWORD^> ^<COMMUNITY^> ^<ROOM_ID^> ^<LOCAL_PATH^>
ECHO.
ECHO Positional parameters
ECHO  ^<USERNAME^> the username used for log in to Caveau
ECHO  ^<PASSWORD^> the password of the above specified user
ECHO  ^<COMMUNITY^> the community login name
ECHO  ^<ROOM_ID^> the room id inside Caveau community where files will be uploaded,
ECHO  and it can be read from the address bar (URL) of your browser when room is open
ECHO  ^<LOCAL_PATH^> the folder in the local file System that will be processed
ECHO  Please note: two subfolders will be created at this location, and all processed
ECHO  files will be moved into one of those depending if upload succeeded or failed
ECHO.
ECHO you can automatically run this script every n minutes (eg.:5 minutes) using Task Scheduler.
ECHO To do that open a CMD prompt with elevated priviledges, and perform the following command:
ECHO schtasks /ru "SYSTEM" /create /sc minute /mo 5 /tn "Caveau-Uploader" /tr %~dp0%0
ECHO INFO: administrator priviledges are required in order to be able to use the parameter /ru "SYSTEM"
ECHO wich will avoid CMD propt to pop up everytime the Task is executed.
ECHO.
ECHO Options
ECHO '/?' show this help text 
GOTO :end

:main
REM counting input param
SET argC=0
FOR %%x IN (%*) DO Set /A argC+=1

IF %argC% == 5 (
  ECHO Using the given custom configuration, using parameters instead of internal default variables.
  SET "USERNAME=%1"
  SET "PASSWORD=%2"
  SET "COMMUNITY=%3"
  SET "ROOM_ID=%4"
  SET "LOCAL_PATH=%5"
) ELSE IF %argC% == 0 (
  ECHO No arguments provided, going to use the default configuration values set inside the script.
) ELSE (
  ECHO Illegal number of parameters
  GOTO :help
  EXIT
)

SETLOCAL ENABLEDELAYEDEXPANSION

REM retrieve token
FOR /f "usebackq tokens=*" %%x IN (`"PowerShell -ExecutionPolicy Bypass -File "%~dp0\authentication.ps1" !USERNAME! !PASSWORD! !COMMUNITY! !BASEURL!"`) DO (
    SET "TOKEN=%%x"
    ECHO !TOKEN!
)

REM checking folders exists
IF NOT EXIST "%LOCAL_PATH%" (
    ECHO 'Local path not found'
    PAUSE
    EXIT
) ELSE IF exist  "%LOCAL_PATH%" (
    IF NOT EXIST "%LOCAL_PATH%/backup" mkdir "%LOCAL_PATH%/backup"
    IF NOT EXIST "%LOCAL_PATH%/errors" mkdir "%LOCAL_PATH%/errors"
)

SETLOCAL DISABLEDELAYEDEXPANSION
REM processing files in LOCAL_PATH folder
FOR /f "usebackq tokens=*" %%A IN (`dir /b /a-d "%LOCAL_PATH%"`) DO (
	SET "FILES_TEMP=%%~A"
    SET "extension=%%~xA"
	CALL :doAll
)
GOTO :finalizing

:doAll
SET FULLPATH=%LOCAL_PATH%/%FILES_TEMP%
SET "filename=%FILES_TEMP%"

IF [%extension%] == [] (
    ECHO "doing nothing"
) ELSE (
    SET extension=%extension:~1%
)

ECHO fullpath : %FULLPATH%
ECHO filename : %filename%
ECHO extension : %extension%

REM Mapping extension to supported mime types [where 'supported' means that caveau will display preview]
IF  "%extension%" == "pdf" (
    SET CTYPE="application/pdf"
) ELSE IF "%extension%" == "PDF" (
    SET CTYPE="application/pdf"

) ELSE IF "%extension%" == "jpeg" (
    SET CTYPE="image/jpeg"
) ELSE IF "%extension%" == "JPEG" (
    SET CTYPE="image/jpeg"
) ELSE IF "%extension%" == "jpg" (
    SET CTYPE="image/jpeg"
) ELSE IF "%extension%" == "JPG" (
    SET CTYPE="image/jpeg"
) ELSE IF "%extension%" == "jpe" (
    SET CTYPE="image/jpeg"
) ELSE IF "%extension%" == "JPE" (
    SET CTYPE="image/jpeg"

) ELSE IF "%extension%" == "png" (
    SET CTYPE="image/png"
) ELSE IF "%extension%" == "PNG" (
    SET CTYPE="image/png"

) ELSE IF "%extension%" == "gif" (
    SET CTYPE="image/gif"
) ELSE IF "%extension%" == "GIF" (
    SET CTYPE="image/gif"

) ELSE IF "%extension%" == "tiff" (
    SET CTYPE="image/tiff"
) ELSE IF "%extension%" == "TIFF" (
    SET CTYPE="image/tiff"

) ELSE IF "%extension%" == "tif" (
    SET CTYPE="image/tiff"
) ELSE IF "%extension%" == "TIF" (
    SET CTYPE="image/tiff"

) ELSE IF "%extension%" == "odp" (
    SET CTYPE="application/vnd.oasis.opendocument.presentation"
) ELSE IF "%extension%" == "ODP" (
    SET CTYPE="application/vnd.oasis.opendocument.presentation"
) ELSE IF "%extension%" == "ods" (
    SET CTYPE="application/vnd.oasis.opendocument.spreadsheet"
) ELSE IF "%extension%" == "ODS" (
    SET CTYPE="application/vnd.oasis.opendocument.spreadsheet"
) ELSE IF "%extension%" == "odt" (
    SET CTYPE="application/vnd.oasis.opendocument.text" 
) ELSE IF "%extension%" == "ODT" (
    SET CTYPE="application/vnd.oasis.opendocument.text" 

) ELSE IF "%extension%" == "doc" (
    SET CTYPE="application/msword"
) ELSE IF "%extension%" == "DOC" (
    SET CTYPE="application/msword"
) ELSE IF "%extension%" == "docx" (
    SET CTYPE="application/vnd.openxmlformats-officedocument.wordprocessingml.document"
) ELSE IF "%extension%" == "DOCX" (
    SET CTYPE="application/vnd.openxmlformats-officedocument.wordprocessingml.document"

) ELSE IF "%extension%" == "xls" (
    SET CTYPE="application/vnd.ms-excel"
) ELSE IF "%extension%" == "XLS" (
    SET CTYPE="application/vnd.ms-excel"
) ELSE IF "%extension%" == "xlt" (
    SET CTYPE="application/vnd.ms-excel"
) ELSE IF "%extension%" == "XLT" (
    SET CTYPE="application/vnd.ms-excel"
) ELSE IF "%extension%" == "xla" (
    SET CTYPE="application/vnd.ms-excel"
) ELSE IF "%extension%" == "XLA" (
    SET CTYPE="application/vnd.ms-excel"
) ELSE IF "%extension%" == "xlsx" (
    SET CTYPE="application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"
) ELSE IF "%extension%" == "XLSX" (
    SET CTYPE="application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"

) ELSE IF "%extension%" == "ppt" (
    SET CTYPE="application/vnd.ms-powerpoint"
) ELSE IF "%extension%" == "PPT" (
    SET CTYPE="application/vnd.ms-powerpoint"
) ELSE IF "%extension%" == "pps" (
    SET CTYPE="application/vnd.ms-powerpoint"
) ELSE IF "%extension%" == "PPS" (
    SET CTYPE="application/vnd.ms-powerpoint"
) ELSE IF "%extension%" == "pptx" (
    SET CTYPE="application/vnd.openxmlformats-officedocument.presentationml.presentation"
) ELSE IF "%extension%" == "PPTX" (
    SET CTYPE="application/vnd.openxmlformats-officedocument.presentationml.presentation"

) ELSE IF "%extension%" == "txt" (
    SET CTYPE="text/plain"
) ELSE IF "%extension%" == "TXT" (
    SET CTYPE="text/plain"

) ELSE IF "%extension%" == "zip" (
    SET CTYPE="application/zip"
) ELSE IF "%extension%" == "ZIP" (
    SET CTYPE="application/zip"

) ELSE IF "%extension%" == "mp4" (
    SET CTYPE="video/mp4"
) ELSE IF "%extension%" == "MP4" (
    SET CTYPE="video/mp4"

) ELSE IF "%extension%" == "m4v" (
    SET CTYPE="video/x-m4v"
) ELSE IF "%extension%" == "M4V" (
    SET CTYPE="video/x-m4v"

) ELSE (
    SET CTYPE="application/octet-stream"
)

ECHO contentent type : %CTYPE%

REM upload each file
FOR /f "usebackq tokens=*" %%K IN (`PowerShell -ExecutionPolicy Bypass -File "%~dp0\upload-file.ps1" %TOKEN% "%LOCAL_PATH%" %CTYPE% %ROOM_ID% "%filename%" "%BASEURL%"`) DO (
    ECHO %%K
)
GOTO :end

:finalizing
ECHO done!
powershell -ExecutionPolicy Bypass -File "%~dp0\logout.ps1" %BASEURL% %TOKEN%
PAUSE
GOTO :end

:end
ECHO ----
