#Write-Host "$($args[0]) - $($args[1]) - $($args[2]) - $($args[3]) - $($args[4]) - $($args[5])"

$Uri="$($args[5])/agora-api/api/v1/rooms/$($args[3])/files";

# this make Invoke-Webrequest use TLS v1.2
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12

$Headers = @{}
$Headers.Add("Authorization","Bearer " + $args[0])
$Headers.Add("Accept","*/*")

# Convert byte-array to string
$enc = [System.Text.Encoding]::GetEncoding("iso-8859-1")

$filePath = $($args[1]) + "/" + $($args[4])
$fileContent = $enc.GetString([System.IO.File]::ReadAllBytes($filePath))
$filename = [Text.Encoding]::Default.GetString([Text.Encoding]::Utf8.GetBytes($($args[4])))

# We need a boundary (something random() will do best)
$boundary = [System.Guid]::NewGuid().ToString()

# Linefeed character
$LF = "`r`n"
  
# Build Body for our form-data manually since PS does not support multipart/form-data out of the box
$body = (
    "--$boundary",
    "Content-Disposition: form-data; name=`"Resource`"",
    "$LF{`"inheritSettings`":true}",
    "--$boundary",
    "Content-Disposition: form-data; name=`"file`"; filename=`"$filename`"",
    "Content-Type: $($args[2])$LF",
    "$fileContent",
    "--$boundary--$LF"
 ) -join $LF

#$body

#echo "------DEBUGGING START"
#echo "uri is : $Uri"
#echo "headers: $($Headers)"
#echo "fields: $($body)"
#echo "boundary: $boundary"
#echo $body
#echo "-------DEBUGGING END"

$STATUS=""
try {
  $RESPONSE=Invoke-WebRequest -UseBasicParsing -Uri $Uri -ContentType "multipart/form-data;boundary=$boundary" -Method Post -Headers $Headers -Body $body
  #$RESPONSE

  if( ($RESPONSE.StatusCode -eq 200) -or ($RESPONSE.StatusCode -eq 201) ) {
    if ( $RESPONSE.tostring().Contains("`"rid`":") ) {
      echo "$($args[4]): [$($RESPONSE.StatusCode)] successfully transferred to Caveau..."
      $STATUS="ok"
    } else {
      echo "$($args[4]): could not be transferred to Caveau (Error $($RESPONSE.StatusCode))"
      $STATUS="nok"
    }
  } else {
    echo "$($args[4]): could not be transferred to Caveau (Error $($RESPONSE.StatusCode))"
    $STATUS="nok"
  }
} catch {
  $streamReader = [System.IO.StreamReader]::new($_.Exception.Response.GetResponseStream())
  $ErrResp = $streamReader.ReadToEnd() | ConvertFrom-Json
  $streamReader.Close()
  echo "$($args[4]): could not be transferred to Caveau (Error $($ErrResp.status))"
  $STATUS="nok"
}

$SRC = $args[1] + "/" + $args[4]
if($STATUS -eq "ok") {
  $DST = $args[1] + "/backup"
  Move-Item -Path $SRC -Destination $DST
} elseif ($STATUS -eq "nok") {
  $DST = $args[1] + "/errors"
  Move-Item -Path $SRC -Destination $DST
} else {
  echo "status is unhandled"
  $DST = $args[1] + "/errors"
  Move-Item -Path $SRC -Destination $DST
}
